<?php
require_once __DIR__ . '/../layout/header.php';
require_once __DIR__ . '/../layout/sidebar.php';
require_once __DIR__ . '/../../core/auth.php';
require_once __DIR__ . '/../../core/drivers.php';
require_once __DIR__ . '/../../core/db.php';

$u = require_login();
$drivers = drivers_list();

// Build map: category -> brand -> drivers[]
$map = [];
foreach ($drivers as $d) {
  $cat = $d['category'];
  $br  = $d['brand'];
  $key = $d['driver_key'];
  $title = $d['profile']['title'] ?? $key;
  if (!isset($map[$cat])) $map[$cat] = [];
  if (!isset($map[$cat][$br])) $map[$cat][$br] = [];
  $map[$cat][$br][] = ['key'=>$key,'title'=>$title];
}

$tenants = [];
if (is_super($u)) {
  $tenants = db_all("SELECT id,name FROM tenants ORDER BY id DESC");
}
?>
<div class="main">
  <div class="card">
    <h2>Devices</h2>

    <?php if (!empty($_GET['err']) && $_GET['err']==='tenant_required'): ?>
      <div class="banner">SuperAdmin: Please select a Tenant before adding a device.</div>
    <?php endif; ?>

    <form method="post" action="index.php" style="margin-bottom:14px;">
      <input type="hidden" name="action" value="device_create">

      <?php if (is_super($u)): ?>
        <div style="margin-bottom:10px;">
          <label>Tenant</label><br>
          <select name="tenant_id" style="width:360px;padding:10px;border-radius:10px;border:1px solid #ddd;">
            <option value="">-- Select Tenant --</option>
            <?php foreach ($tenants as $t): ?>
              <option value="<?= (int)$t['id'] ?>"><?= (int)$t['id'] ?> — <?= h($t['name']) ?></option>
            <?php endforeach; ?>
          </select>
        </div>
      <?php endif; ?>

      <div style="display:grid;grid-template-columns:repeat(3,1fr);gap:10px;">
        <div><label>Device Name</label><br><input name="device_name" style="width:100%;padding:10px;border-radius:10px;border:1px solid #ddd;"></div>
        <div><label>IP</label><br><input name="ip_address" style="width:100%;padding:10px;border-radius:10px;border:1px solid #ddd;"></div>

        <div>
          <label>Type</label><br>
          <select id="device_category" name="device_category" style="width:100%;padding:10px;border-radius:10px;border:1px solid #ddd;">
            <option value="router">Router</option>
            <option value="switch">Switch</option>
            <option value="olt">OLT</option>
          </select>
        </div>

        <div>
          <label>Brand</label><br>
          <select id="brand" name="brand" style="width:100%;padding:10px;border-radius:10px;border:1px solid #ddd;">
            <option value="">-- Select Brand --</option>
          </select>
        </div>

        <div>
          <label>Import/Driver Key</label><br>
          <select id="driver_key" name="driver_key" style="width:100%;padding:10px;border-radius:10px;border:1px solid #ddd;">
            <option value="">-- Select Driver --</option>
          </select>
          <div style="font-size:12px;color:#6b7280;margin-top:4px;">
            প্রতিটি vendor/brand এর জন্য আলাদা command profile (driver) ব্যবহার হয়।
          </div>
        </div>

        <div>
          <label>Protocol</label><br>
          <select name="protocol" style="width:100%;padding:10px;border-radius:10px;border:1px solid #ddd;">
            <option value="default">Use Default</option>
            <option value="ssh">SSH</option>
            <option value="telnet">Telnet</option>
          </select>
        </div>

        <div><label>Port</label><br><input name="port" value="22" style="width:100%;padding:10px;border-radius:10px;border:1px solid #ddd;"></div>
        <div><label>Username</label><br><input name="username" style="width:100%;padding:10px;border-radius:10px;border:1px solid #ddd;"></div>
        <div><label>Password</label><br><input type="password" name="password" style="width:100%;padding:10px;border-radius:10px;border:1px solid #ddd;"></div>
        <div><label>Interval Days</label><br><input name="interval_days" value="7" style="width:100%;padding:10px;border-radius:10px;border:1px solid #ddd;"></div>
      </div>

      <div style="margin-top:10px;">
        <button class="btn primary" type="submit">Add Device (auto first backup)</button>
      </div>
    </form>

    <table>
      <thead><tr>
        <?php if (isset($devices[0]['tenant_name'])): ?><th>Tenant</th><?php endif; ?>
        <th>Name</th><th>IP</th><th>Type</th><th>Brand</th><th>Driver</th><th>Last Backup</th><th>Actions</th>
      </tr></thead>
      <tbody>
        <?php foreach ($devices as $d): ?>
          <tr>
            <?php if (isset($d['tenant_name'])): ?><td><?= h($d['tenant_name']) ?></td><?php endif; ?>
            <td><?= h($d['device_name']) ?></td>
            <td><?= h($d['ip_address']) ?></td>
            <td><?= h($d['device_category']) ?></td>
            <td><?= h($d['brand']) ?></td>
            <td><?= h($d['driver_key']) ?></td>
            <td><?= h($d['last_backup_at'] ?? '-') ?></td>
            <td>
              <form method="post" action="index.php" onsubmit="return confirm('Delete device? This will remove backup files too (if policy allows).');" style="display:inline;">
                <input type="hidden" name="action" value="device_delete">
                <input type="hidden" name="device_id" value="<?= (int)$d['id'] ?>">
                <button class="btn danger" type="submit">Delete</button>
              </form>
            </td>
          </tr>
        <?php endforeach; ?>
        <?php if (!$devices): ?><tr><td colspan="8">No devices</td></tr><?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<script>
  const DRIVER_MAP = <?= json_encode($map, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES) ?>;
  const DEFAULT_BRANDS = {
    router: ['mikrotik','cisco','juniper'],
    switch: ['mikrotik','cisco','juniper'],
    olt: ['bdcom','vsol','cdata','ecom','avies','proton','airnet']
  };

  function setOptions(sel, options, placeholder) {
    sel.innerHTML = '';
    const ph = document.createElement('option');
    ph.value = '';
    ph.textContent = placeholder;
    sel.appendChild(ph);
    options.forEach(o => {
      const op = document.createElement('option');
      op.value = o.value;
      op.textContent = o.label;
      sel.appendChild(op);
    });
  }

  function refreshBrands() {
    const cat = document.getElementById('device_category').value;
    const brandSel = document.getElementById('brand');
    const driverSel = document.getElementById('driver_key');

    let brands = Object.keys(DRIVER_MAP[cat] || {});
    // include default brands so dropdown shows even before drivers are added
    (DEFAULT_BRANDS[cat]||[]).forEach(b=>{ if (!brands.includes(b)) brands.push(b); });
    brands = brands.sort();
    setOptions(brandSel, brands.map(b=>({value:b,label:b})), '-- Select Brand --');
    setOptions(driverSel, [], '-- Select Driver --');
  }

  function refreshDrivers() {
    const cat = document.getElementById('device_category').value;
    const brand = document.getElementById('brand').value;
    const driverSel = document.getElementById('driver_key');
    const list = ((DRIVER_MAP[cat]||{})[brand]||[]);
    setOptions(driverSel, list.map(x=>({value:x.key,label:x.title})), '-- Select Driver --');
  }

  document.getElementById('device_category').addEventListener('change', refreshBrands);
  document.getElementById('brand').addEventListener('change', refreshDrivers);

  // init
  refreshBrands();
</script>

<?php require_once __DIR__ . '/../layout/footer.php'; ?>
