<?php
/**
 * bKash PGW placeholder.
 * Real integration requires bKash official API credentials and callback verification.
 * Put credentials in settings (GLOBAL scope) and implement token + createPayment + executePayment.
 */
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/settings.php';

function bkash_settings_get(): array {
  $rows = db_all("SELECT k,v FROM settings WHERE scope='GLOBAL' AND k LIKE 'bkash_%'");
  $out = [];
  foreach ($rows as $r) $out[$r['k']] = $r['v'];
  return $out;
}

function bkash_create_payment_link(int $invoice_id): string {
  $s = bkash_settings_get();
  $enabled = ($s['bkash_enabled'] ?? '0') === '1';
  $payUrl = trim((string)($s['bkash_pay_url'] ?? ''));

  if ($enabled && $payUrl) {
    $inv = db_one("SELECT id, tenant_id, total_amount FROM invoices WHERE id=?", [$invoice_id]);
    if (!$inv) return "index.php?page=invoices";
    $qs = http_build_query([
      'invoice_id' => (int)$inv['id'],
      'tenant_id'  => (int)$inv['tenant_id'],
      'amount'     => (float)$inv['total_amount'],
      'success'    => (site_url()."/index.php?action=pay_success&id=".(int)$inv['id']),
      'fail'       => (site_url()."/index.php?page=invoice_pay&id=".(int)$inv['id']."&err=failed"),
    ]);
    return rtrim($payUrl,'?&') . (str_contains($payUrl,'?') ? '&' : '?') . $qs;
  }

  // fallback: internal demo pay page
  return "index.php?page=invoice_pay&id=" . $invoice_id;
}
(int $invoice_id): string {
  // For now: local pay page which simulates redirect flow
  return "index.php?page=invoice_pay&id=" . $invoice_id;
}
