<?php
require_once __DIR__ . '/../core/auth.php';
require_once __DIR__ . '/../core/helpers.php';
require_once __DIR__ . '/../core/settings.php';
require_once __DIR__ . '/../core/audit.php';

function site_settings_page(): void {
  $u = require_login();
  if (!is_super($u)) { http_response_code(403); exit('Forbidden'); }

  $data = [
    'site_name' => setting_get('GLOBAL', null, 'site_name', 'Sweet Online'),
    'support_email' => setting_get('GLOBAL', null, 'support_email', 'support@example.com'),
    'support_phone' => setting_get('GLOBAL', null, 'support_phone', '+8801XXXXXXXXX'),
    'support_address' => setting_get('GLOBAL', null, 'support_address', 'Dhaka, Bangladesh'),
  ];

  include __DIR__ . '/../views/settings/site.php';
}

function site_settings_update_action(): void {
  $u = require_login();
  if (!is_super($u)) { http_response_code(403); exit('Forbidden'); }

  $site_name = trim($_POST['site_name'] ?? 'Sweet Online');
  $support_email = trim($_POST['support_email'] ?? '');
  $support_phone = trim($_POST['support_phone'] ?? '');
  $support_address = trim($_POST['support_address'] ?? '');

  setting_set('GLOBAL', null, 'site_name', $site_name);
  setting_set('GLOBAL', null, 'support_email', $support_email);
  setting_set('GLOBAL', null, 'support_phone', $support_phone);
  setting_set('GLOBAL', null, 'support_address', $support_address);

  audit_log(null, (int)$u['id'], 'SITE_SETTINGS_UPDATED', 'settings', null, [
    'site_name'=>$site_name,
    'support_email'=>$support_email,
    'support_phone'=>$support_phone,
    'support_address'=>$support_address,
  ]);

  redirect('index.php?page=site_settings&msg=updated');
}
