<?php
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/backup_engine.php';

function purge_device_files(int $tenant_id, array $device): void {
  $cfg = app_config();
  $root = rtrim($cfg['app']['backup_root'], '/');
  $cat = $device['device_category'];
  $brand = $device['brand'];

  $dir = "{$root}/{$tenant_id}/{$cat}/{$brand}";
  if (!is_dir($dir)) return;

  // This purges files matching device_name__ip__*.ext (simple)
  $safeName = preg_replace('/[^a-zA-Z0-9_\-]/', '_', $device['device_name']);
  $safeIp = preg_replace('/[^0-9a-fA-F\.\:]/', '_', $device['ip_address']);
  foreach (glob($dir . "/{$safeName}__{$safeIp}__*") as $f) {
    @unlink($f);
  }

  // DB cleanup for backups pointing to removed files
  db_exec("DELETE FROM backups WHERE tenant_id=? AND device_id=?", [$tenant_id, (int)$device['id']]);
}
