<?php
require_once __DIR__ . '/db.php';

function notify_create(?int $tenant_id, ?int $user_id, string $type, string $title, string $body, ?string $link = null): void {
  db_exec("INSERT INTO notifications (tenant_id,user_id,type,title,body,link_url) VALUES (?,?,?,?,?,?)",
    [$tenant_id, $user_id, $type, $title, $body, $link]
  );
}

function notify_unread_count(array $u): int {
  if (is_super($u)) {
    $row = db_one("SELECT COUNT(*) c FROM notifications WHERE is_read=0 AND (tenant_id IS NULL)");
    return (int)($row['c'] ?? 0);
  }
  $tid = tenant_id_of($u);
  $row = db_one("SELECT COUNT(*) c FROM notifications WHERE is_read=0 AND tenant_id=?", [$tid]);
  return (int)($row['c'] ?? 0);
}
