<?php
require_once __DIR__ . '/db.php';

function enc_key(): string {
  $cfg = app_config();
  return (string)$cfg['security']['enc_key'];
}

function encrypt_text(string $plain): string {
  $key = hash('sha256', enc_key(), true);
  $iv = random_bytes(16);
  $cipher = openssl_encrypt($plain, 'AES-256-CBC', $key, OPENSSL_RAW_DATA, $iv);
  return base64_encode($iv . $cipher);
}

function decrypt_text(string $enc): string {
  $raw = base64_decode($enc, true);
  if ($raw === false || strlen($raw) < 17) return '';
  $iv = substr($raw, 0, 16);
  $cipher = substr($raw, 16);
  $key = hash('sha256', enc_key(), true);
  $plain = openssl_decrypt($cipher, 'AES-256-CBC', $key, OPENSSL_RAW_DATA, $iv);
  return $plain === false ? '' : $plain;
}
