<?php
require_once __DIR__ . '/../core/db.php';
require_once __DIR__ . '/../core/auth.php';
require_once __DIR__ . '/../core/helpers.php';
require_once __DIR__ . '/../core/audit.php';

function tenants_page(): void {
  $u = require_login();
  if (!is_super($u)) { http_response_code(403); exit('Forbidden'); }
  $tenants = db_all("SELECT * FROM tenants ORDER BY id DESC");
  include __DIR__ . '/../views/tenants/index.php';
}


function tenant_create_action(): void {
  $u = require_login();
  if (!is_super($u)) { http_response_code(403); exit('Forbidden'); }

  $name = trim($_POST['name'] ?? '');
  $status = $_POST['status'] ?? 'ACTIVE';

  $allow_admin_device_delete = isset($_POST['allow_admin_device_delete']) ? 1 : 0;
  $allow_admin_backup_delete = isset($_POST['allow_admin_backup_delete']) ? 1 : 0;
  $purge_files_on_device_delete = isset($_POST['purge_files_on_device_delete']) ? 1 : 0;
  $allow_admin_manual_backup = isset($_POST['allow_admin_manual_backup']) ? 1 : 0;

  $admin_username = trim($_POST['admin_username'] ?? '');
  $admin_password = (string)($_POST['admin_password'] ?? '');

  if (!$name || !$admin_username || !$admin_password) {
    http_response_code(400); exit('Tenant name + admin credentials required');
  }

  // create tenant
  db_exec("INSERT INTO tenants (name,status,allow_admin_device_delete,allow_admin_backup_delete,purge_files_on_device_delete,allow_admin_manual_backup)
           VALUES (?,?,?,?,?,?)",
    [$name,$status,$allow_admin_device_delete,$allow_admin_backup_delete,$purge_files_on_device_delete,$allow_admin_manual_backup]
  );
  $tid = (int)db()->lastInsertId();

  // create tenant admin user
  $hash = password_hash($admin_password, PASSWORD_BCRYPT);
  db_exec("INSERT INTO users (tenant_id,username,password_hash,role,status) VALUES (?,?,?,?, 'ACTIVE')",
    [$tid,$admin_username,$hash,'tenant_admin']
  );

  audit_log(null, (int)$u['id'], 'TENANT_CREATED', 'tenant', $tid, ['admin_username'=>$admin_username]);
  redirect('index.php?page=tenants&msg=created');
}

function tenant_edit_page(): void {
  $u = require_login();
  if (!is_super($u)) { http_response_code(403); exit('Forbidden'); }
  $id = (int)($_GET['id'] ?? 0);
  $t = db_one("SELECT * FROM tenants WHERE id=?", [$id]);
  if (!$t) { http_response_code(404); exit('Not found'); }
  include __DIR__ . '/../views/tenants/edit.php';
}

function tenant_admin_reset_password_action(): void {
  $u = require_login();
  if (!is_super($u)) { http_response_code(403); exit('Forbidden'); }

  $tenantId = (int)($_POST['tenant_id'] ?? 0);
  $adminUsername = trim($_POST['admin_username'] ?? '');
  $newPass = (string)($_POST['new_password'] ?? '');
  if (!$tenantId || !$newPass) { redirect('index.php?page=tenant_edit&id='.$tenantId.'&err=pass_required'); }

  if ($adminUsername) {
    $admin = db_one("SELECT * FROM users WHERE tenant_id=? AND username=? AND role='tenant_admin' LIMIT 1", [$tenantId,$adminUsername]);
  } else {
    $admin = db_one("SELECT * FROM users WHERE tenant_id=? AND role='tenant_admin' ORDER BY id ASC LIMIT 1", [$tenantId]);
  }
  if (!$admin) { redirect('index.php?page=tenant_edit&id='.$tenantId.'&err=admin_not_found'); }

  $hash = password_hash($newPass, PASSWORD_BCRYPT);
  db_exec("UPDATE users SET password_hash=? WHERE id=?", [$hash, (int)$admin['id']]);

  audit_log($tenantId, (int)$u['id'], 'TENANT_ADMIN_PASSWORD_RESET', 'user', (int)$admin['id'], []);
  redirect('index.php?page=tenant_edit&id='.$tenantId.'&msg=updated');
}

function tenant_update_action(): void {
  $u = require_login();
  if (!is_super($u)) { http_response_code(403); exit('Forbidden'); }
  $id = (int)($_POST['id'] ?? 0);

  $name = trim($_POST['name'] ?? '');
  $status = $_POST['status'] ?? 'ACTIVE';

  $allow_admin_device_delete = isset($_POST['allow_admin_device_delete']) ? 1 : 0;
  $allow_admin_backup_delete = isset($_POST['allow_admin_backup_delete']) ? 1 : 0;
  $purge_files_on_device_delete = isset($_POST['purge_files_on_device_delete']) ? 1 : 0;
  $allow_admin_manual_backup = isset($_POST['allow_admin_manual_backup']) ? 1 : 0;

  db_exec("UPDATE tenants SET name=?, status=?,
           allow_admin_device_delete=?, allow_admin_backup_delete=?, purge_files_on_device_delete=?, allow_admin_manual_backup=?
           WHERE id=?",
    [$name,$status,$allow_admin_device_delete,$allow_admin_backup_delete,$purge_files_on_device_delete,$allow_admin_manual_backup,$id]
  );
  audit_log(null, (int)$u['id'], 'TENANT_POLICY_UPDATED', 'tenant', $id, [
    'allow_admin_device_delete'=>$allow_admin_device_delete,
    'allow_admin_backup_delete'=>$allow_admin_backup_delete,
    'purge_files_on_device_delete'=>$purge_files_on_device_delete,
    'allow_admin_manual_backup'=>$allow_admin_manual_backup,
  ]);

  redirect('index.php?page=tenants&msg=updated');
}
