<?php
require_once __DIR__ . '/../app/core/db.php';
require_once __DIR__ . '/../app/core/billing.php';
require_once __DIR__ . '/../app/core/helpers.php';
require_once __DIR__ . '/../app/core/notifications.php';
require_once __DIR__ . '/../app/core/telegram.php';
require_once __DIR__ . '/../app/core/pgw_bkash.php';
require_once __DIR__ . '/../app/core/audit.php';

$cfg = app_config();
$day = (int)date('j');
if ($day !== (int)($cfg['billing']['invoice_day'] ?? 1)) exit;

$period = ym_this_month(); // current month invoice period
$snaps = db_all("SELECT * FROM billing_snapshots WHERE snapshot_for_period_ym=?", [$period]);

foreach ($snaps as $s) {
  $tid = (int)$s['tenant_id'];
  if (invoice_exists($tid, $period)) continue;

  $invId = create_invoice_from_snapshot($tid, $period, null);
  if (!$invId) continue;

  $payLink = bkash_create_payment_link($invId);
  notify_create($tid, null, 'INVOICE_CREATED', 'Invoice created', "New invoice for {$period}. Please pay within 10 days.", $payLink);
  telegram_send($tid, "🧾 Invoice CREATED\nPeriod: {$period}\nInvoice #{$invId}\nPay: {$payLink}");
  telegram_send(null, "🧾 Invoice CREATED\nTenant {$tid} Period {$period} Invoice #{$invId}");
  audit_log($tid, null, 'INVOICE_CREATED', 'invoice', $invId, ['period'=>$period]);
}
