<?php
require_once __DIR__ . '/../app/core/db.php';
require_once __DIR__ . '/../app/core/billing.php';
require_once __DIR__ . '/../app/core/helpers.php';
require_once __DIR__ . '/../app/core/notifications.php';
require_once __DIR__ . '/../app/core/telegram.php';
require_once __DIR__ . '/../app/core/audit.php';

$cfg = app_config();
$day = (int)date('j');
if ($day !== (int)($cfg['billing']['snapshot_day'] ?? 25)) exit;

$nextPeriod = ym_next_month(); // next month
$tenants = db_all("SELECT id,name FROM tenants WHERE status IN ('ACTIVE','SUSPENDED_UNPAID')"); // snapshot even if suspended
foreach ($tenants as $t) {
  $tid = (int)$t['id'];
  if (billing_snapshot_exists($tid, $nextPeriod)) continue;
  create_billing_snapshot($tid, $nextPeriod);
  notify_create($tid, null, 'BILLING_SNAPSHOT', 'Billing snapshot created', "Device count snapshot saved for {$nextPeriod}", 'index.php?page=invoices');
  telegram_send($tid, "🧾 Billing snapshot saved for {$nextPeriod} (day 25).");
  audit_log($tid, null, 'BILLING_SNAPSHOT_CREATED', 'tenant', $tid, ['period'=>$nextPeriod]);
}
