<?php
require_once __DIR__ . '/../layout/header.php';
require_once __DIR__ . '/../../core/helpers.php';
require_once __DIR__ . '/../../core/settings.php';
?>
<div class="main" style="max-width:980px;margin:0 auto;">
  <div class="card" style="padding:22px;">
    <h1 style="margin-top:0;">Network Device Backup & Billing Platform — <?= h(site_name()) ?></h1>
    <p style="color:#374151;line-height:1.6;">
      <b>backup.apzone.top</b> হলো একটি মাল্টি-টেন্যান্ট (Multi Admin) সল্যুশন যেখানে Router / Switch / OLT ডিভাইসের
      কনফিগ/ব্যাকআপ ফাইল স্বয়ংক্রিয়ভাবে সংগ্রহ করে সিকিউরভাবে সংরক্ষণ করা হয়। একই সাথে প্রতি মাসে ডিভাইস সংখ্যা অনুযায়ী
      বিলিং, ইনভয়েস, পেমেন্ট এবং ডিউ হলে অটো সাসপেন্ড—সব কিছু এক জায়গায়।
    </p>
    <div style="margin-top:14px;">
      <a class="btn primary" href="login.php">Login</a>
    </div>
  </div>

  <div class="card">
    <h2>Key Features</h2>
    <ul style="line-height:1.8;color:#374151;">
      <li><b>Device Types:</b> Router / Switch / OLT</li>
      <li><b>Brand + Driver Key:</b> প্রতিটি ব্র্যান্ড/মডেলের জন্য আলাদা কমান্ড প্রোফাইল (future addable)</li>
      <li><b>Auto First Backup:</b> ডিভাইস Add হলেই প্রথম ব্যাকআপ অটো queue হয়ে রান হবে</li>
      <li><b>Schedule:</b> 1/3/7/15 দিন বা Custom interval (Per device)</li>
      <li><b>Retention:</b> 6 মাস পুরোনো ব্যাকআপ অটো ক্লিনআপ</li>
      <li><b>Billing:</b> 25 তারিখ snapshot → 1 তারিখ invoice → 10 দিনের মধ্যে pay না করলে auto suspend</li>
      <li><b>Notifications:</b> Dashboard notification + Telegram bot (Tenant bot আলাদা, Super bot আলাদা)</li>
      <li><b>Security:</b> Tenant isolation (এক admin অন্য admin এর ফাইল/ডাটা দেখতে পারবে না), SHA256 integrity</li>
    </ul>
  </div>

  <div class="card">
    <h2>Why Choose Us</h2>
    <ul style="line-height:1.8;color:#374151;">
      <li><b>Rule-based access:</b> Super Admin / Tenant Admin / Staff—যার যেই menu নাই, দেখাবে না</li>
      <li><b>Scalable driver system:</b> নতুন vendor/brand যুক্ত করা সহজ (শুধু নতুন driver file যোগ)</li>
      <li><b>Single dashboard control:</b> Backup, billing, tenant management, audit—সব একসাথে</li>
      <li><b>Future ready:</b> OLT brands (BDCOM/VSOL/CData/Ecom/Avies/Proton/Airnet) সহজে extend করা যাবে</li>
    </ul>
  </div>

  <div class="card">
    <h2>About Us</h2>
    <p style="color:#374151;line-height:1.7;">
      আমরা ISP/Network অপারেশনকে সহজ করতে ডিভাইস কনফিগ ব্যাকআপ, দেখতে/ডাউনলোড করতে পারা,
      এবং নিয়মিত বিলিং অটোমেশন—এই তিনটি জিনিস এক প্ল্যাটফর্মে এনেছি।
      এই সিস্টেমটি AdminLTE-style UI ও Raw PHP + SQL ভিত্তিতে তৈরি করা হয়েছে, যাতে হালকা, দ্রুত ও সহজে কাস্টমাইজ করা যায়।
    </p>
  </div>

  <div class="card">
    <h2>Contact</h2>
    <div style="display:grid;grid-template-columns:repeat(2,1fr);gap:10px;">
      <div>
        <b>Support Email</b><br>
        <span style="color:#374151;"><?= h(site_support_email()) ?></span>
      </div>
      <div>
        <b>Phone</b><br>
        <span style="color:#374151;"><?= h(site_phone()) ?></span>
      </div>
      <div>
        <b>Address</b><br>
        <span style="color:#374151;"><?= h(site_address()) ?></span>
      </div>
      <div>
        <b>Business Hours</b><br>
        <span style="color:#374151;">Sat–Thu: 10:00 AM – 8:00 PM</span>
      </div>
    </div>
    <div style="margin-top:10px;color:#6b7280;font-size:12px;">
      (আপনি চাইলে এই Contact তথ্যগুলো settings থেকে editable করা যাবে—পরের ধাপে যোগ করা যাবে।)
    </div>
  </div>

  <div class="card" style="text-align:center;color:#6b7280;">
    © <?= date('Y') ?> <?= h(site_name()) ?> • backup.apzone.top
  </div>
</div>
<?php require_once __DIR__ . '/../layout/footer.php'; ?>
