<?php
require_once __DIR__ . '/layout/header.php';
require_once __DIR__ . '/layout/sidebar.php';
require_once __DIR__ . '/../core/db.php';
require_once __DIR__ . '/../core/auth.php';
require_once __DIR__ . '/../core/guard.php';
$u = require_login();
require_tenant_active_or_invoice($u, is_super($u)); // super can always
?>
<div class="main">
  <div class="card">
    <h2>Dashboard</h2>
    <?php if (!is_super($u)): 
      $t = db_one("SELECT * FROM tenants WHERE id=?", [(int)$u['tenant_id']]);
      if ($t && $t['status'] !== 'ACTIVE'): ?>
        <div class="banner">
          Due to unpaid invoice your billing activities temporarily suspended.
          <a class="btn primary" href="index.php?page=invoices">Pay Now</a>
        </div>
      <?php endif; endif; ?>

    <?php if (is_super($u)): 
      $totTen = db_one("SELECT COUNT(*) c FROM tenants")['c'] ?? 0;
      $totDev = db_one("SELECT COUNT(*) c FROM devices WHERE deleted_at IS NULL")['c'] ?? 0;
      $exp = db_one("SELECT SUM(total_amount) s FROM invoices WHERE period_ym=?",
        [date('Y-m')])['s'] ?? 0;
      $col = db_one("SELECT SUM(total_amount) s FROM invoices WHERE period_ym=? AND status='PAID'",
        [date('Y-m')])['s'] ?? 0;
      $failToday = db_one("SELECT COUNT(*) c FROM backups WHERE status='failed' AND DATE(created_at)=CURDATE()")['c'] ?? 0;
    ?>
      <p>Total tenants: <b><?= (int)$totTen ?></b> | Total devices: <b><?= (int)$totDev ?></b></p>
      <p>This month expected: <b><?= (int)$exp ?></b> | Collected: <b><?= (int)$col ?></b></p>
      <p>Failed backups today: <b><?= (int)$failToday ?></b></p>
    <?php else:
      $tid=(int)$u['tenant_id'];
      $dev = db_one("SELECT COUNT(*) c FROM devices WHERE tenant_id=? AND deleted_at IS NULL",[$tid])['c'] ?? 0;
      $fail = db_one("SELECT COUNT(*) c FROM backups WHERE tenant_id=? AND status='failed' AND DATE(created_at)=CURDATE()",[$tid])['c'] ?? 0;
      $succ = db_one("SELECT COUNT(*) c FROM backups WHERE tenant_id=? AND status='success' AND DATE(created_at)=CURDATE()",[$tid])['c'] ?? 0;
      $unpaid = db_one("SELECT id,total_amount,due_date FROM invoices WHERE tenant_id=? AND status='UNPAID' ORDER BY id DESC LIMIT 1",[$tid]);
    ?>
      <p>Your devices: <b><?= (int)$dev ?></b></p>
      <p>Backups today: ✅ <b><?= (int)$succ ?></b> | ❌ <b><?= (int)$fail ?></b></p>
      <?php if ($unpaid): ?>
        <div class="banner">
          Unpaid invoice: <b>#<?= (int)$unpaid['id'] ?></b> Amount: <b><?= (int)$unpaid['total_amount'] ?></b> Due: <b><?= h($unpaid['due_date']) ?></b>
          <a class="btn primary" href="index.php?page=invoice_pay&id=<?= (int)$unpaid['id'] ?>">Pay Now</a>
        </div>
      <?php endif; ?>
    <?php endif; ?>
  </div>
</div>
<?php require_once __DIR__ . '/layout/footer.php'; ?>
