# AdminLTE Device Backup + Billing (Raw PHP)

This is a **raw PHP + MySQL** multi-tenant device backup platform with:
- Tenants (client admins) + Super Admin
- Per-tenant isolation (DB + filesystem)
- Device types: Router / Switch / OLT
- Brand + driver_key profiles (file-based drivers)
- SSH/Telnet option (global default + per-device override)
- Auto first-backup on device add (queued)
- Scheduled backups (interval days per device)
- 6 month retention purge
- Billing slabs + snapshot on 25th + invoice generation on 1st + 10 day due + auto-suspend
- bKash PGW placeholders (SuperAdmin settings only)
- Notifications + Telegram bot (Super + Tenant)

> NOTE: SSH/Telnet command execution is provided as **placeholders**.
> To make it fully functional, install phpseclib via Composer and implement the
> real connectors inside `app/core/connectors/`.

## Quick start
1) Create MySQL database, import `sql/schema.sql`
2) Copy `app/config/config.sample.php` to `app/config/config.php` and edit DB credentials + encryption key
3) Point web root to `public/`
4) Run cron jobs (examples in `cron/cron_examples.txt`)

Default pages:
- `public/index.php?page=login`
- `public/index.php?page=dashboard`

## Roles
- super_admin, super_staff, tenant_admin, tenant_staff

## Important policies
- Strict suspension: if tenant is SUSPENDED_UNPAID => only invoice/pay pages allowed.
- Tenant staff can never delete devices/backups.
- Tenant admin delete permissions are controlled by SuperAdmin -> Tenants -> Policies.


## Default Super Admin
- Username: `superadmin`
- Password: `Sweet@123`

Change password later by updating `users.password_hash` with a new bcrypt hash.

## Apache setup (recommended)
Set the domain **DocumentRoot** to the `public/` folder.

Example:
- Domain: `backup.apzone.top`
- DocumentRoot: `/home/USERNAME/backup.apzone.top/public`

Then:
- Home/Landing: `https://backup.apzone.top/`  (shows landing if not logged in)
- Login: `https://backup.apzone.top/login.php`  (or `/?page=login`)
- Dashboard: `https://backup.apzone.top/?page=dashboard`

Make sure `app/config/config.php` exists (copy from sample).

## Staff management
- Tenant Admin can create/enable/disable/reset password for Tenant Staff.
- Only Super Admin can reset Tenant Admin password.
- Tenant Staff can never delete devices/backups.

## Backup delete policy
- Tenant staff: never.
- Tenant admin: only if tenant policy `allow_admin_backup_delete=1`.
- Super admin: always.

## Cron (billing)
Run `cron/daily.php` daily using cPanel Cron (Asia/Dhaka). See `cron/README.md`.
