<?php
require_once __DIR__ . '/../app/core/db.php';
require_once __DIR__ . '/../app/core/notifications.php';
require_once __DIR__ . '/../app/core/telegram.php';
require_once __DIR__ . '/../app/core/audit.php';

$over = db_all("SELECT i.id, i.tenant_id, i.period_ym, i.due_date, i.total_amount
               FROM invoices i
               JOIN tenants t ON t.id=i.tenant_id
               WHERE i.status='UNPAID' AND i.due_date < CURDATE() AND t.status='ACTIVE'");

foreach ($over as $inv) {
  $tid = (int)$inv['tenant_id'];
  db_exec("UPDATE tenants SET status='SUSPENDED_UNPAID', suspended_reason=?, suspended_at=NOW() WHERE id=?",
    ['Unpaid invoice overdue', $tid]
  );

  $msg = "Due to unpaid invoice, your billing activities temporarily suspended. Please pay now.";
  notify_create($tid, null, 'BILLING_SUSPENDED', 'Account suspended', $msg, "index.php?page=invoice_pay&id=".(int)$inv['id']);
  telegram_send($tid, "⛔ ACCOUNT SUSPENDED\nInvoice #{$inv['id']} overdue. Amount {$inv['total_amount']}. Pay now: index.php?page=invoice_pay&id={$inv['id']}");
  telegram_send(null, "⛔ TENANT SUSPENDED\nTenant {$tid} Invoice #{$inv['id']} overdue.");
  audit_log($tid, null, 'TENANT_SUSPENDED_UNPAID', 'invoice', (int)$inv['id'], []);
}
