<?php
function h(string $s): string { return htmlspecialchars($s, ENT_QUOTES, 'UTF-8'); }

function redirect(string $url): void {
  header("Location: {$url}");
  exit;
}

function now_dt(): string { return date('Y-m-d H:i:s'); }
function now_date(): string { return date('Y-m-d'); }

function ym_next_month(?string $ym=null): string {
  $dt = $ym ? DateTime::createFromFormat('Y-m', $ym) : new DateTime('first day of this month');
  $dt->modify('+1 month');
  return $dt->format('Y-m');
}

function ym_this_month(): string { return date('Y-m'); }
