<?php
require_once __DIR__ . '/../layout/header.php';
require_once __DIR__ . '/../layout/sidebar.php';
require_once __DIR__ . '/../../core/helpers.php';
$u = require_login();
?>
<div class="main">
  <div class="card">
    <h2>Payment Gateway (bKash) Settings</h2>
    <?php if (!empty($_GET['msg'])): ?><div class="banner">Saved.</div><?php endif; ?>

    <form method="post" action="index.php">
      <input type="hidden" name="action" value="pgw_settings_update">

      <label style="display:block;margin-bottom:10px;">
        <input type="checkbox" name="bkash_enabled" <?= ($data['bkash_enabled']==='1'?'checked':'') ?>>
        Enable bKash payment
      </label>

      <div style="margin-bottom:10px;">
        <label>Mode</label><br>
        <select name="bkash_mode" style="width:260px;padding:10px;border-radius:10px;border:1px solid #ddd;">
          <option value="merchant_url" <?= ($data['bkash_mode']==='merchant_url'?'selected':'') ?>>Merchant Checkout URL</option>
          <option value="tokenized" <?= ($data['bkash_mode']==='tokenized'?'selected':'') ?>>Tokenized API (Skeleton)</option>
        </select>
      </div>

      <div style="display:grid;grid-template-columns:repeat(2,1fr);gap:10px;">
        <div>
          <label>Merchant Checkout URL (External Pay URL)</label><br>
          <input name="bkash_pay_url" value="<?= h($data['bkash_pay_url']) ?>" placeholder="https://pay.example.com/checkout"
                 style="width:100%;padding:10px;border-radius:10px;border:1px solid #ddd;">
          <div style="font-size:12px;color:#6b7280;margin-top:4px;">
            যদি আপনি external checkout URL ব্যবহার করেন, সিস্টেম invoice_id, amount, tenant_id querystring হিসেবে পাঠাবে।
          </div>
        </div>

        <div>
          <label>Note (shown on invoice pay page)</label><br>
          <input name="bkash_note" value="<?= h($data['bkash_note']) ?>"
                 style="width:100%;padding:10px;border-radius:10px;border:1px solid #ddd;">
        </div>

        <div>
          <label>Success URL (optional)</label><br>
          <input name="bkash_success_url" value="<?= h($data['bkash_success_url']) ?>" placeholder="https://backup.apzone.top/?action=pay_success&invoice_id=..."
                 style="width:100%;padding:10px;border-radius:10px;border:1px solid #ddd;">
        </div>

        <div>
          <label>Fail URL (optional)</label><br>
          <input name="bkash_fail_url" value="<?= h($data['bkash_fail_url']) ?>"
                 style="width:100%;padding:10px;border-radius:10px;border:1px solid #ddd;">
        </div>
      </div>

      <div style="margin-top:12px;">
        <button class="btn primary" type="submit">Save</button>
      </div>
    
      <div class="card" style="margin-top:12px;background:#f8fafc;">
        <h3>Callback Verification</h3>
        <label>Callback Secret</label><br>
        <input name="bkash_callback_secret" value="<?= h($data['bkash_callback_secret']) ?>" placeholder="auto-generated if empty"
               style="width:100%;padding:10px;border-radius:10px;border:1px solid #ddd;">
        <div style="margin-top:10px;color:#6b7280;font-size:12px;">
          Callback URL: <code><?= h(site_url()) ?>/index.php?action=bkash_callback</code><br>
          Required params: <code>invoice_id,trx_id,status,amount,sig</code><br>
          sig = HMAC-SHA256(invoice_id|trx_id|status|amount_2dp)
        </div>
      </div>

      <div class="card" style="margin-top:12px;background:#f8fafc;">
        <h3>Tokenized API (Skeleton fields)</h3>
        <div style="display:grid;grid-template-columns:repeat(2,1fr);gap:10px;">
          <div><label>Base URL</label><br><input name="bkash_base_url" value="<?= h($data['bkash_base_url']) ?>" style="width:100%;padding:10px;border-radius:10px;border:1px solid #ddd;"></div>
          <div><label>App Key</label><br><input name="bkash_app_key" value="<?= h($data['bkash_app_key']) ?>" style="width:100%;padding:10px;border-radius:10px;border:1px solid #ddd;"></div>
          <div><label>App Secret</label><br><input name="bkash_app_secret" value="<?= h($data['bkash_app_secret']) ?>" style="width:100%;padding:10px;border-radius:10px;border:1px solid #ddd;"></div>
          <div><label>Username</label><br><input name="bkash_username" value="<?= h($data['bkash_username']) ?>" style="width:100%;padding:10px;border-radius:10px;border:1px solid #ddd;"></div>
          <div><label>Password</label><br><input name="bkash_password" value="<?= h($data['bkash_password']) ?>" style="width:100%;padding:10px;border-radius:10px;border:1px solid #ddd;"></div>
        </div>
        <div style="margin-top:10px;color:#6b7280;font-size:12px;">
          Tokenized skeleton: <code>app/core/bkash_tokenized.php</code>
        </div>
      </div>

    </form>

    <div class="card" style="margin-top:12px;background:#f8fafc;">
      <h3>How Pay Link Works</h3>
      <p style="color:#374151;line-height:1.6;">
        Invoice Pay page থেকে “Pay Now” চাপলে:
      </p>
      <ul style="color:#374151;line-height:1.8;">
        <li>যদি External Pay URL দেওয়া থাকে, user redirect হবে: <code>bkash_pay_url?invoice_id=...&tenant_id=...&amount=...</code></li>
        <li>না থাকলে, demo mode হিসেবে system নিজে “Mark as Paid” বাটন দেখাবে (testing)</li>
      </ul>
    </div>
  </div>
</div>
<?php require_once __DIR__ . '/../layout/footer.php'; ?>
