<?php require_once __DIR__ . '/../../core/auth.php'; require_once __DIR__ . '/../../core/notifications.php'; ?>
<?php require_once __DIR__ . '/../../core/helpers.php'; ?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <?php require_once __DIR__ . '/../../core/settings.php'; ?>
  <title><?= h(site_name()) ?> - Device Backup</title>
  <style>
    body{font-family:Arial, sans-serif; margin:0; background:#f6f7fb;}
    .top{background:#111827;color:#fff;padding:12px 16px;display:flex;justify-content:space-between;align-items:center;}
    .wrap{display:flex;}
    .side{width:220px;background:#0f172a;color:#cbd5e1;min-height:calc(100vh - 48px);padding:12px;}
    .side a{display:block;color:#cbd5e1;text-decoration:none;padding:8px 10px;border-radius:8px;margin:4px 0;}
    .side a:hover{background:#1f2937;}
    .main{flex:1;padding:16px;}
    .card{background:#fff;border-radius:12px;padding:14px;box-shadow:0 1px 3px rgba(0,0,0,.08);margin-bottom:12px;}
    table{width:100%;border-collapse:collapse;}
    th,td{padding:10px;border-bottom:1px solid #eee;font-size:14px;text-align:left;}
    .btn{display:inline-block;padding:8px 10px;border-radius:8px;border:1px solid #ddd;background:#fff;text-decoration:none;color:#111;}
    .btn.primary{background:#2563eb;color:#fff;border-color:#2563eb;}
    .btn.danger{background:#dc2626;color:#fff;border-color:#dc2626;}
    .badge{padding:2px 8px;border-radius:999px;background:#e5e7eb;font-size:12px;}
    .banner{background:#fff7ed;border:1px solid #fed7aa;padding:10px 12px;border-radius:10px;margin-bottom:12px;}
  </style>
<style>.stat{background:#f8fafc;border:1px solid #e5e7eb;border-radius:12px;padding:12px;}</style>
</head>
<body>
<div class="top">
  <div><b>Device Backup</b></div>
  <div>
    <?php $u = current_user(); if ($u): ?>
      <span class="badge">Notifications: <?= (int)notify_unread_count($u) ?></span>
      <a class="btn" href="index.php?page=logout">Logout</a>
    <?php endif; ?>
  </div>
</div>
<div class="wrap">
