<?php
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/auth.php';

function audit_log(?int $tenant_id, ?int $actor_user_id, string $action_key, ?string $entity_type=null, ?int $entity_id=null, array $meta=[]): void {
  $ip = $_SERVER['REMOTE_ADDR'] ?? null;
  $ua = $_SERVER['HTTP_USER_AGENT'] ?? null;
  $meta_json = $meta ? json_encode($meta, JSON_UNESCAPED_UNICODE) : null;

  db_exec("INSERT INTO audit_logs (tenant_id,actor_user_id,action_key,entity_type,entity_id,ip,user_agent,meta_json)
           VALUES (?,?,?,?,?,?,?,?)",
    [$tenant_id, $actor_user_id, $action_key, $entity_type, $entity_id, $ip, $ua, $meta_json]
  );
}
