<?php
require_once __DIR__ . '/../core/auth.php';
require_once __DIR__ . '/../core/helpers.php';
require_once __DIR__ . '/../core/settings.php';
require_once __DIR__ . '/../core/audit.php';

function pgw_settings_page(): void {
  $u = require_login();
  if (!is_super($u)) { http_response_code(403); exit('Forbidden'); }

  $data = [
    'bkash_enabled' => setting_get('GLOBAL', null, 'bkash_enabled', '0'),
    'bkash_mode' => setting_get('GLOBAL', null, 'bkash_mode', 'merchant_url'),
    'bkash_callback_secret' => setting_get('GLOBAL', null, 'bkash_callback_secret', ''),
    'bkash_base_url' => setting_get('GLOBAL', null, 'bkash_base_url', ''),
    'bkash_app_key' => setting_get('GLOBAL', null, 'bkash_app_key', ''),
    'bkash_app_secret' => setting_get('GLOBAL', null, 'bkash_app_secret', ''),
    'bkash_username' => setting_get('GLOBAL', null, 'bkash_username', ''),
    'bkash_password' => setting_get('GLOBAL', null, 'bkash_password', ''),
    'bkash_pay_url' => setting_get('GLOBAL', null, 'bkash_pay_url', ''), // optional external checkout URL
    'bkash_success_url' => setting_get('GLOBAL', null, 'bkash_success_url', ''), // optional
    'bkash_fail_url' => setting_get('GLOBAL', null, 'bkash_fail_url', ''), // optional
    'bkash_note' => setting_get('GLOBAL', null, 'bkash_note', 'Pay to re-enable service'),
  ];

  include __DIR__ . '/../views/settings/pgw.php';
}

function pgw_settings_update_action(): void {
  $u = require_login();
  if (!is_super($u)) { http_response_code(403); exit('Forbidden'); }

  $enabled = isset($_POST['bkash_enabled']) ? '1' : '0';

  $mode = $_POST['bkash_mode'] ?? 'merchant_url';
  if (!in_array($mode, ['merchant_url','tokenized'], true)) $mode = 'merchant_url';
  $cbSecret = trim((string)($_POST['bkash_callback_secret'] ?? ''));
  if (!$cbSecret) { $cbSecret = bin2hex(random_bytes(16)); }

  $baseUrl = trim((string)($_POST['bkash_base_url'] ?? ''));
  $appKey = trim((string)($_POST['bkash_app_key'] ?? ''));
  $appSecret = trim((string)($_POST['bkash_app_secret'] ?? ''));
  $uname = trim((string)($_POST['bkash_username'] ?? ''));
  $pwd = trim((string)($_POST['bkash_password'] ?? ''));
  $payUrl = trim($_POST['bkash_pay_url'] ?? '');
  $successUrl = trim($_POST['bkash_success_url'] ?? '');
  $failUrl = trim($_POST['bkash_fail_url'] ?? '');
  $note = trim($_POST['bkash_note'] ?? '');

  setting_set('GLOBAL', null, 'bkash_enabled', $enabled);
  setting_set('GLOBAL', null, 'bkash_mode', $mode);
  setting_set('GLOBAL', null, 'bkash_callback_secret', $cbSecret);
  setting_set('GLOBAL', null, 'bkash_base_url', $baseUrl);
  setting_set('GLOBAL', null, 'bkash_app_key', $appKey);
  setting_set('GLOBAL', null, 'bkash_app_secret', $appSecret);
  setting_set('GLOBAL', null, 'bkash_username', $uname);
  setting_set('GLOBAL', null, 'bkash_password', $pwd);

  setting_set('GLOBAL', null, 'bkash_pay_url', $payUrl);
  setting_set('GLOBAL', null, 'bkash_success_url', $successUrl);
  setting_set('GLOBAL', null, 'bkash_fail_url', $failUrl);
  setting_set('GLOBAL', null, 'bkash_note', $note);

  audit_log(null, (int)$u['id'], 'PGW_SETTINGS_UPDATED', 'settings', null, ['bkash_enabled'=>$enabled]);

  redirect('index.php?page=pgw_settings&msg=updated');
}
